# Coffee Machine Program

## Overview

The Coffee Machine Program is a command-line application that simulates a coffee vending machine. Users can interact with the program to choose and customize their coffee, manage resources, and make transactions. The program provides a seamless and enjoyable coffee ordering experience.

## Key Features

- **User Interaction:**
  - Users are prompted to choose their desired coffee type (espresso, latte, cappuccino).

- **Power Off:**
  - The machine can be turned off using a secret command.

- **Resource Report:**
  - Users can request a report to view current resource levels (water, milk, coffee, money).

- **Resource Management:**
  - The program checks and manages resources to ensure there are enough ingredients to make the selected coffee.

- **Coin Processing:**
  - Users can insert coins, and the program calculates the total value based on coin denominations.

- **Transaction Handling:**
  - The program validates the user's payment, provides change if necessary, and dispenses the coffee.

- **Coffee Brewing:**
  - When the transaction is successful, the program brews the coffee and serves it to the user.

## Usage

1. Run the program using your preferred Python environment.
2. Follow the prompts to select your coffee type and customize as desired.
3. Insert coins when prompted and complete the transaction.
4. Enjoy your freshly brewed coffee!

## How to Run

1. Clone the repository:
   ```bash
   git clone <repository_url>
   cd coffee-machine-program
   ```

2. Run the program:
   ```bash
   python coffee_machine.py
   ```

## Contribution Guidelines

Contributions to the Coffee Machine Program are welcome! If you'd like to contribute, please follow these guidelines:

1. Fork the repository.
2. Create a new branch for your feature/fix: `git checkout -b feature/your-feature`.
3. Make your changes and commit them: `git commit -m 'Add feature/fix'`.
4. Push to the branch: `git push origin feature/your-feature`.
5. Create a pull request, explaining the changes made.

